/*
	hook.c
*/

#include "hook.h"

void **hookFindExportAddr( const char *modname, const char *libname, unsigned int nid )
{
	SceModule *module;
	struct SceLibraryEntryTable *entry;
	unsigned int i = 0, *entrytable = NULL;
	
	/* [h̃W[KvȃW[ */
	module = sceKernelFindModuleByName( modname );
	if( ! module ) return NULL;
	
	/* W[KvȃCu */
	while( i < module->ent_size ){
		entry = (struct SceLibraryEntryTable *)( (unsigned int)(module->ent_top) + i );
		
		if( ( libname && ( strcmp( libname, entry->libname ) == 0 ) ) || ( ! libname && ! entry->libname ) ){
			entrytable = entry->entrytable;
			break;
		}
		
		i += entry->len * sizeof( uint32_t );
	}
	
	if( ! entrytable || ! entry->stubcount ) return NULL;
	
	/* CuGNX|[gĂNID̊i[AhXԂ */
	for( i = 0; i < entry->stubcount; i++ ){
		if( entrytable[i] == nid ) return (void **)&(entrytable[entry->vstubcount + entry->stubcount + i]);
	}
	
	return NULL;
}

void **hookFindSyscallAddr( void **addr )
{
	/*
		̊֐́ANID瓱郁AhX
		ۂɃVXeR[Onḧʒu肷B
		
		PSPLINK̃R[hQlɂĂ܂B
	*/
	void **cop0_ctrl_register_12;
	struct hook_syscall_table_header *syscall_table;
	void **syscall_entry;
	unsigned int i, total_entries;
	
	if( ! addr ) return NULL;
	
	/*
		CFC0̓RvZbT0̐䃌WX^ǂݍޖ߂̂悤B
		߂MFC0悤A͔ėpWX^ǂݍޖ߂炵Aʂ̒lԂĂB
		
		̃CCAZuŁARvZbT012Ԗڂ̐䃌WX^cop0_ctrl_register_12ϐփRs[B
		12Ԗڂ̐䃌WX^ɂ̓VXeR[e[ũAhXZbgĂ͗lB
	*/
	asm( "cfc0 %0, $12;" : "=r"( cop0_ctrl_register_12 ) );
	
	/* cop0_ctrl_register_12QƂāAVXeR[e[u擾 */
	syscall_table = *cop0_ctrl_register_12;
	
	/* VXeR[e[ũwb_΂āAGg擾 */
	syscall_entry = (void **)( (unsigned int)syscall_table + sizeof( struct hook_syscall_table_header ) );
	
	/* wb_Zăe[u̎cTCYGgŎ擾 */
	total_entries = ( syscall_table->size - sizeof( struct hook_syscall_table_header ) ) / sizeof( void* );
	
	/* ړI̗OnhAAhXԂ */
	for( i = 0; i < total_entries; i++ ){
		if( syscall_entry[i] == *addr ) return &(syscall_entry[i]);
	}
	
	return NULL;
}

void hookFunc( void **addr, void *hookfunc )
{
	unsigned int intc;
	
	if( ! addr || ! hookfunc ) return;
	
	/* Z}tHŔr */
	intc = pspSdkDisableInterrupts();
	
	/* ֐ύX */
	*addr = hookfunc;
	
	/* ύXKp */
	sceKernelDcacheWritebackInvalidateRange( addr, sizeof( addr ) );
	sceKernelIcacheInvalidateRange( addr, sizeof( addr ) );
	
	pspSdkEnableInterrupts( intc );
}
